<?php

/**
 * The template for displaying product content in the single-product.php template
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-single-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.6.0
 */

defined('ABSPATH') || exit;

global $product;

/**
 * Hook: woocommerce_before_single_product.
 *
 * @hooked wc_print_notices - 10
 */
do_action('woocommerce_before_single_product');


if (post_password_required()) {
	echo get_the_password_form(); // WPCS: XSS ok.
	return;
}
$product = wc_get_product(get_the_id());
?>
<div class="container-fluid">
	<div class="page_product">
		<div class="wo_breadcrumb">
			<?php woocommerce_breadcrumb(); ?>
		</div>
	</div>
	<div id="product-<?php the_ID(); ?>" <?php wc_product_class('', $product); ?>>
		<article class="wo_product-sin">
			<div class="row mr-0">
				<div class="col-12"> 
					<div class="offer_1 sale_countdown singlesale_countdown_mobile d-block d-md-none">
						<?php theme_product_sale_countdown(); ?>
					</div>
					<div class="wo-product-hed mo-background_white">
						<?php echo the_title('<h1 class="product_title entry-title">', '</h1>'); ?>
						<span class="wo-product-title-en">
							<?php woocommerce_show_product_loop_sale_flash(); ?>
							<?php echo metaboxs_get_meta('metaboxs_metaboxs1'); ?>
						</span>
						<div class="d-block d-lg-none">
							<div class="wo-product-category" style="border-bottom: 1px solid aliceblue;">
								<?php get_template_part('themeplat-part/single-product/rating', 'rating'); ?>
								<ul>
									<li>
										<?php echo woocommerce_template_single_meta(); ?>
										<?php get_template_part('themeplat-part/single-product/meta', 'meta'); ?>
									</li>
								</ul>
							</div>
							<ul class="single_product_tools_negarin" style="margin: 0;">
								<?php if (class_exists('YITH_WCWL_Privacy')) : ?>
									<li>
										<?php function_exists('YITH_WCWL_Frontend') && YITH_WCWL_Frontend()->print_button(); ?>
									</li>
								<?php endif;
								if (in_array('woo-smart-compare/wpc-smart-compare.php', apply_filters('active_plugins', get_option('active_plugins')))) :
								?>
									<li>
										<a data-toggle="tooltip" data-placement="bottom" data-original-title="<?php _e('Comparison', 'negarin'); ?>" class="compare">
											<?php echo do_shortcode('[woosc]'); ?>
										</a>
									</li>
								<?php endif; ?>
								<li>
									<a href="#modal-11" data-toggle="tooltip" data-placement="bottom" data-original-title="<?php _e('share', 'negarin'); ?>" class=" action-btn-product-share"><?php _e('send', 'negarin'); ?></a>
								</li>
								<?php do_action('single_product_tools_negarin'); ?>
							</ul>
						</div>
					</div>
				</div>
				<div class="col-12 col-lg-4" style=" overflow: hidden;">
					<div class="wo-product_img mo-background_white no-padding">
						<div class="wo-product-gallery">
							<div class="d-none d-lg-block">
								<ul class="single_product_tools_negarin">
									<?php if (class_exists('YITH_WCWL_Privacy')) : ?>
										<li>
											<?php function_exists('YITH_WCWL_Frontend') && YITH_WCWL_Frontend()->print_button(); ?>
										</li>
									<?php endif;
									if (in_array('woo-smart-compare/wpc-smart-compare.php', apply_filters('active_plugins', get_option('active_plugins')))) :
									?>
										<li>
											<a data-toggle="tooltip" data-placement="bottom" data-original-title="<?php _e('Comparison', 'negarin'); ?>" class="compare">
												<?php echo do_shortcode('[woosc]'); ?> </a>
										</li>
									<?php endif; ?>
									<li>
										<a href="#modal-11" data-toggle="tooltip" data-placement="bottom" data-original-title="<?php _e('share', 'negarin'); ?>" class=" action-btn-product-share"><?php _e('send', 'negarin'); ?></a>
										<div data-ml-modal id="modal-11">
											<a href="#!" class="modal-overlay"></a>
											<div class="modal-dialog modal-dialog-lg">
												<?php get_template_part('themeplat-part/single-product/product-icon-box', 'product-icon-box'); ?>
											</div>
										</div>
									</li>
									<?php do_action('single_product_tools_negarin'); ?>
								</ul>
							</div>
							<div class="wo-gallery-lar_pho">
								<?php do_action('woocommerce_before_single_product_summary'); ?>
							</div>
						</div>
					</div>
				</div>
				<div class="col-12 col-lg-8">
					<div class="row">
						<div class="col-12 col-lg-7 mo-background_white">
							<div class="wo-product-config_page">
								<div class="wo-product-category d-none d-lg-block">
									<?php get_template_part('themeplat-part/single-product/rating', 'rating'); ?>
									<ul>
										<li>
											<?php echo woocommerce_template_single_meta(); ?>
											<?php get_template_part('themeplat-part/single-product/meta', 'meta'); ?>
										</li>
									</ul>
								</div>
								<div class="wo-product__params">
									<?php $repeatable_fields2 = get_post_meta($post->ID, 'repeatable_fields2', true);
									if ($repeatable_fields2) : ?>
										<div class="spoiler">
											<ul class="hidden-text" data-title="ویژگی های محصول">
												<?php foreach ($repeatable_fields2 as $field) { ?>
													<li>
														<?php if ($field['name2'] != '') echo '<span class="field">' . esc_attr($field['name2']) . '</span>'; ?> :&nbsp;
 
														<?php if ($field['url2'] != '') echo '<span class="field">' . esc_attr($field['url2']) . '</span>'; ?>
													</li>
												<?php } ?>
											</ul>
										</div>
										<div class="c-product__additional-info">
											<!-- add icon-->
										</div>
									<?php endif;
									if (metaboxs_get_meta('metaboxs_metaboxs3')) { ?>
										<div class="c-product__additional-item">
											<?php echo metaboxs_get_meta('metaboxs_metaboxs3'); ?>
										</div>
									<?php } ?>
								</div>
								<div class="d-none d-lg-block"><?php get_sidebar('shop-single') ?></div>
							</div>
						</div>
						<div class="col-12 col-lg-5 pl-0 wo-product-config_page" style="margin-top:1rem">
						<div class="offer_time_porduct d-none d-md-block"></div>
							<div class="d-none d-md-block">
								<?php theme_product_sale_countdown(); ?>
							</div>
							<div class="mo-background_white">
								<div class="pric-box">
									<div class="marketing_u wo-product__seller-info">
										<div class="wo-product-seller-row wo-product__seller-row--seller wo-product__seller-row">
											<?php
											if (original_product_get_meta('Marketing')) {
												echo '<div class="custom_marketing">';
												$product = wc_get_product($post->ID);
												$title = $product->get_meta('custom_text_field_title');
												if ($title) {
													printf(
														esc_html($title)
													);
												}
												echo '</div>';
												$repeatable_fields3 = get_post_meta($post->ID, 'repeatable_fields3', true);
												if ($repeatable_fields3) : ?>
													<ul>
														<?php foreach ($repeatable_fields3 as $field) { ?>
															<li>
																<a href="<?php if ($field['url3'] != '') echo  esc_attr($field['url3']); ?>" target="block" title="خرید از : <?php if ($field['name3'] != '') echo esc_attr($field['name3']); ?>">
																	<button type="submit" name="add-to-cart" value="15" class="btn-add-to-cart bth_quick_info marketing_u">
																		<span class="btn-add-to-cart__txt">
																			<i class="fal fa-cart-plus" aria-hidden="true"></i>
																			<?php if ($field['name3'] != '') echo esc_attr($field['name3']); ?>
																		</span>
																	</button>
																</a>
															</li>
														<?php } ?>
													</ul>
													<?php endif;
											} else {
												if (!$product->is_in_stock()) {
													echo metaboxs_get_meta('metaboxs_metaboxs4');
												} else {
													if (function_exists('dokan')) { ?>
														<p id="price-shop_table_one">
															<i class="fal fa-store-alt"></i>
															<?php echo sold_by(); ?>
														</p>
													<?php } ?>
													<p id="price-shop_table_one">
														<i class="fal fa-shield-check"></i>
														<span>
															<?php
															if (original_product_get_meta('Warranty')) {
																echo 'گارانتی اصالت و سلامت فیزیکی کالا';
															} else {
																echo 'گارانتی سلامت فیزیکی کالا';
															}
															?>
														</span>
													</p>
													<?php
													if (metaboxs_get_meta('Delivery_Time')) : ?>
														<p id="price-shop_table_one">
															<i class="fal fa-hourglass-end"></i>
															<span>
																حداکثر تا <?php echo metaboxs_get_meta('Delivery_Time'); ?> روز تحویل داده می شود.
															</span>
														</p>
													<?php
													endif;
													if ($product->get_stock_quantity()) :
													?>
														<p id="price-shop_table_one">
															<i class="fal fa-warehouse-alt"></i>
															<span class="stock_form">
																<?php do_action('show_stock_woo_negarin'); ?>
															</span>
														</p>
											<?php
													endif;
												}
												do_action('woocommerce_single_product_summary');
											} ?>
										</div>
									</div>
									<?php if (original_product_get_meta('Marketing_link')) : ?>
										<div class="wo-product__price-survey-question">
											<ul class="accordion-menu">
												<li class="accordion_lists">
													<div class="dropdownlink"><i class="fas fa-link"></i>
														<?php _e('Useful links', 'negarin'); ?>
														<i class="fa fa-chevron-down" aria-hidden="true"></i>
													</div>
													<div class="accordion__header">
														<?php $repeatable_fields = get_post_meta($post->ID, 'repeatable_fields', true);
														if ($repeatable_fields) : ?>
															<ul>
																<?php foreach ($repeatable_fields as $field) { ?>
																	<li>
																		<a href="<?php if ($field['url'] != '') echo esc_attr($field['url']); ?>">
																			<?php if ($field['name'] != '') echo '<span class="field">' . esc_attr($field['name']) . '</span>'; ?>
																		</a>
																	</li>
																<?php } ?>
															</ul>
														<?php endif; ?>
													</div>
												</li>
											</ul>
										</div>
									<?php endif; ?>
								</div>
							</div>
						</div>
					</div>
				</div>
		</article>
	</div>
	<?php 
		$show__product_offer_single = ot_get_option('show__product_offer_single', true);
		if ($show__product_offer_single == 'on'):
		get_template_part('themeplat/single/product-offer', 'product_offer');
		endif;
		?>
	<div class="row">
		<div class="col-sm-12">
			<div class="wo-tabs-info">
				<?php do_action('woocommerce_after_single_product_summary'); ?>
			</div>
		</div>
	</div>
	<?php do_action('woocommerce_after_single_product'); ?>
</div>