<?php

/**
 * Cross-sells
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/cart/cross-sells.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see 	    https://docs.woocommerce.com/document/template-structure/
 * @package 	WooCommerce/Templates
 * @version     4.4.0
 */

if (!defined('ABSPATH')) {
	exit;
}

if ($cross_sells) : ?>

	<section class="wo-slider-products wo-slider_box has-placeholder">
		<div class="wo-headline">
			<span><?php _e('You may be interested in&hellip;', 'woocommerce'); ?></span>
			<a href="#" class="wo-swiper__show-more">بیشتر</a>
		</div>
		<div class="wo-box">
			<div class="swiper-container">
				<div class="swiper-wrapper">
					<div class="owl-one owl-carousel owl-theme sec-promotions" style=" width: 100%;">
						<?php foreach ($cross_sells as $cross_sell) :

							$post_object = get_post($cross_sell->get_id());

							setup_postdata($GLOBALS['post'] = &$post_object);

							wc_get_template_part('content', 'product'); ?>

						<?php endforeach; ?>
					</div>
				</div>
			</div>
		</div>
	</section>
<?php endif;

wp_reset_postdata();
?>
<script>
	jQuery(document).ready(function($) {

		$('.owl-one').owlCarousel({
			items: 1,
			rtl: true,
			lazyLoad: true,
			autoWidth: false,
			margin: 20,
			nav: true,
			responsive: {
				0: {
					items: 1
				},
				480: {
					items: 2
				},
				786: {
					items: 4
				},
				992: {
					items: 5
				}
			}
		});



		$('.owl-two').owlCarousel({
			items: 1,
			rtl: true,
			lazyLoad: true,
			autoWidth: false,
			margin: 20,
			nav: true,
			dots: true,
			autoplay: true,
			loop: true,
			responsive: {
				0: {
					items: 1
				},
				480: {
					items: 2
				},
				786: {
					items: 4
				},
				992: {
					items: 5
				}
			}
		});

		/*Change css of links on click*/

		/*showing/hiding particular carousels on clicking links*/


	});
</script>