<?php
/**
 * Elementor Box Content Responsive Widget.
 *
 */
use \Elementor\Group_Control_Image_Size;


 class Slider extends \Elementor\Widget_Base {

 	public function get_name() {
 		return 'slider';
 	}

 	public function get_title() {
 		return __( 'slider', 'negarin' );
 	}

 	public function get_icon() {
 		return 'eicon-slides';
 	}

 	public function get_categories() {
 		return [ 'elementor-widget-be' ];
 	}

  private function grid_get_all_post_type_categories( $post_type ) {
    $options = array();

    if ( $post_type == 'post' ) {
      $taxonomy = 'category';
    } else {
      $taxonomy = 'product_cat';
    }

    // Get categories for post type.
    $terms = get_terms(
      array(
        'taxonomy' => $taxonomy,
        'hide_empty' => false,
      )
    );

    foreach ( $terms as $term ) {
      $options[ $term->slug ] = $term->name;
    }

    return $options;
  }
  private function grid_get_all_post_types() {
   $options = array();
   $exclude = array( 'attachment', 'elementor_widget_be' ); // excluded post types

   $args = array(
     'public' => true,
   );

   foreach ( get_post_types( $args, 'objects' ) as $post_type ) {

     if ( ! isset( $post_type->name ) ) {
       continue;
     }

     if ( ! isset( $post_type->label ) ) {
       continue;
     }

     if ( in_array( $post_type->name, $exclude ) === true ) {
       continue;
     }

     $options[ $post_type->name ] = $post_type->label;
   }

   return $options;
 }
       protected function register_controls()
    {
        $this->init_content_general_controls();
    }

    protected function init_content_general_controls() {
  $this->start_controls_section(
    'section_content',
    [
      'label' => __( 'Content', 'negarin' ),
    ]
  );
  $this->add_control(
    'grid_style',
    [
      'label' => __( 'Grid Style', 'negarin' ),
      'type' => \Elementor\Controls_Manager::SELECT,
      'default' => '1',
      'options' => [
      '1' => esc_html__( 'Layout 1', 'negarin' ),
      ],
    ]
    );
 $this->end_controls_section();
 $this->start_controls_section(
  'content_section',
  [
    'label' => __( 'Content', 'negarin' ),
    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
  ]
);
$repeater = new \Elementor\Repeater();

$repeater->add_control(
  'image',
  [
    'label' => __( 'Choose Image slider', 'negarin' ),
    'type' => \Elementor\Controls_Manager::MEDIA,
    'default' => [
      'url' => \Elementor\Utils::get_placeholder_image_src(),
    ],
  ]
);
$repeater->add_group_control(
  \Elementor\Group_Control_Image_Size::get_type(),
  [
    'name' => 'thumbnail', // Usage: `{name}_size` and `{name}_custom_dimension`, in this case `thumbnail_size` and `thumbnail_custom_dimension`.
    'default' => 'full',
    'separator' => 'none',
  ]
    );

$repeater->add_control(
  'website_link',
  [
    'label' => __( 'Link', 'negarin' ),
    'type' => \Elementor\Controls_Manager::URL,
    'placeholder' => __( 'https://your-link.com', 'negarin' ),
    'show_external' => true,
    'default' => [
      'url' => '',
      'is_external' => true,
      'nofollow' => true,
    ],
  ]
);
$this->add_control(
  'list',
  [
    'label' => __( 'Repeater List', 'negarin' ),
    'type' => \Elementor\Controls_Manager::REPEATER,
    'fields' => $repeater->get_controls(),
    'default' => [
      [
        'list_title' => __( 'Title #1', 'negarin' ),
        'list_content' => __( 'Item content. Click the edit button to change this text.', 'negarin' ),
      ],
      [
        'list_title' => __( 'Title #2', 'negarin' ),
        'list_content' => __( 'Item content. Click the edit button to change this text.', 'negarin' ),
      ],
    ],
    'title_field' => '{{{ list_title }}}',
  ]
);

$this->end_controls_section();
}


 protected function render() {
       $settings = $this->get_settings(); ?>
       <script>
           $('.owl-two.owl-carousel').owlCarousel({
            items: 1,
            rtl: true,
            lazyLoad: true,
            autoWidth: false,
            navText: ['<i class="fal fa-chevron-right"></i>', '<i class="fal fa-chevron-left"></i>'],
            nav: true,
            dots: true,
            autoplay:true,
            loop:true,
            responsive:{ 0:{ items:1, nav:false, }, 600:{ items:1, nav:false, }, 1000:{ items:1 } }
          });
       </script>
       <div class="container">
           <div class="sec-casino-games" style="">
           <div class="owl-two owl-carousel owl-theme sec-promotions" style=" width: 100%;">
           <?php foreach (  $settings['list'] as $item ) { ?>
                 <div class="swiper-container">
                   <div class="swiper-wrapper">
                     <a href="<?php echo $item['website_link']['url']; ?>" class="wo-main-slider__slide swiper-slide">
                       <?php echo Group_Control_Image_Size::get_attachment_image_html( $item, 'thumbnail', 'image' ); ?>
                     </a>
                   </div>
                 </div>
            <?php } ?>
            </div>
          </div>
       </div>
       <?php
     }
   }
