<?php
/**
 * Elementor Box Content Responsive Widget.
 *
 */

 class Article_2 extends \Elementor\Widget_Base {

 	public function get_name() {
 		return 'article-2';
 	}

 	public function get_title() {
 		return __( 'Article 2', 'negarin' );
 	}

 	public function get_icon() {
 		return 'eicon-image-box';
 	}

 	public function get_categories() {
 		return [ 'elementor-widget-be' ];
 	}

  private function grid_get_all_post_type_categories( $post_type ) {
    $options = array();

    if ( $post_type == 'post' ) {
      $taxonomy = 'category';
    } else {
      $taxonomy = 'product_cat';
    }

    // Get categories for post type.
    $terms = get_terms(
      array(
        'taxonomy' => $taxonomy,
        'hide_empty' => false,
      )
    );

    foreach ( $terms as $term ) {
      $options[ $term->slug ] = $term->name;
    }

    return $options;
  }
  private function grid_get_all_post_types() {
   $options = array();
   $exclude = array( 'attachment', 'elementor_widget_be' ); // excluded post types

   $args = array(
     'public' => true,
   );

   foreach ( get_post_types( $args, 'objects' ) as $post_type ) {

     if ( ! isset( $post_type->name ) ) {
       continue;
     }

     if ( ! isset( $post_type->label ) ) {
       continue;
     }

     if ( in_array( $post_type->name, $exclude ) === true ) {
       continue;
     }

     $options[ $post_type->name ] = $post_type->label;
   }

   return $options;
 }



       protected function register_controls()
    {
        $this->init_content_general_controls();
    }

    protected function init_content_general_controls() {
   $this->start_controls_section(
     'section_content',
     [
       'label' => __( 'Content', 'negarin' ),
     ]
   );
   $this->add_control(
     'title',
     [
       'label' => __( 'Title', 'negarin' ),
       'type' => \Elementor\Controls_Manager::TEXT,
     ]
   );
   $this->add_control(
     'title_more',
     [
       'label' => __( 'Title More', 'negarin' ),
       'type' => \Elementor\Controls_Manager::TEXT,
     ]
   );
   // Post type.
   $this->add_control(
     'grid_post_type',
     [
       'type'    => \Elementor\Controls_Manager::SELECT,
       'label'   => '<i class="fa fa-tag"></i> ' . __( 'Post Type', 'negarin' ),
       'default' => 'post',
       'options' => $this->grid_get_all_post_types(),
     ]
   );
   $this->add_control(
     'grid_items',
     [
       'type'        => \Elementor\Controls_Manager::NUMBER,
       'label'       => '<i class="fa fa-th-large"></i> ' . __( 'Items', 'negarin' ),
       'placeholder' => __( 'How many items?', 'negarin' ),
       'default'     => 4,
     ]
   );

   // Post categories.
   $this->add_control(
     'grid_post_categories',
     [
       'type'    => \Elementor\Controls_Manager::SELECT,
       'label'   => '<i class="fa fa-folder"></i> ' . __( 'Category', 'negarin' ),
       'options' => $this->grid_get_all_post_type_categories( 'post' ),
       'condition' => [
         'grid_post_type' => 'post',
       ],
     ]
   );
   $this->add_control(
     'show_more',
     [
       'label' => __( 'Show more', 'negarin' ),
       'type' => \Elementor\Controls_Manager::SWITCHER,
       'label_on' => __( 'Show', 'negarin' ),
       'label_off' => __( 'Hide', 'negarin' ),
       'return_value' => 'yes',
       'default' => 'yes',
     ]
   );
   $this->add_control(
     'website_link',
     [
       'label' => __( 'Link More', 'negarin' ),
       'type' => \Elementor\Controls_Manager::URL,
       'placeholder' => __( 'https://your-link.com', 'negarin' ),
       'show_external' => true,
       'default' => [
         'url' => '',
         'is_external' => true,
         'nofollow' => true,
       ],
     ]
   );
   $this->add_control(
     'grid_pagination',
     [
       'label' => '<i class="fa fa-arrow-circle-right"></i> ' . __( 'Pagination', 'negarin' ),
       'type' => \Elementor\Controls_Manager::SWITCHER,
       'default' => '',
     ]
   );
   // Order by.
   $this->add_control(
     'grid_order_by',
     [
       'type'    => \Elementor\Controls_Manager::SELECT,
       'label'   => '<i class="fa fa-sort"></i> ' . __( 'Order by', 'negarin' ),
       'default' => 'date',
       'options' => [
         'date'          => __( 'Date', 'negarin' ),
         'title'         => __( 'Title', 'negarin' ),
         'modified'      => __( 'Modified date', 'negarin' ),
         'comment_count' => __( 'Comment count', 'negarin' ),
         'rand'          => __( 'Random', 'negarin' ),
       ],
     ]
   );

   // Price.
   $this->add_control(
     'grid_content_price',
     [
       'label' => '<i class="fa fa-usd"></i> ' . __( 'Price', 'negarin' ),
       'type' => \Elementor\Controls_Manager::SWITCHER,
       'default' => 'yes',
       'condition' => [
         'section_grid.grid_post_type' => 'product',
       ],
     ]
   );
   $this->end_controls_section();
   $this->start_controls_section(
     'section_query',
     [
       'label' => __( 'icon', 'negarin' ),
     ]
   );
   		$this->add_control(
   			'icon_1',
   			[
   				'label' => __( 'Icons one', 'negarin' ),
          'type' => \Elementor\Controls_Manager::ICONS,
          'default' => [
            'value' => 'fas fa-star',
            'library' => 'solid',
          ],
   			]
   		);
   		$this->add_control(
   			'icon_2',
   			[
   				'label' => __( 'Icons two', 'negarin' ),
          'type' => \Elementor\Controls_Manager::ICONS,
          'default' => [
            'value' => 'fas fa-star',
            'library' => 'solid',
          ],
   			]
   		);
   		$this->add_control(
   			'icon_3',
   			[
   				'label' => __( 'Icons three', 'negarin' ),
          'type' => \Elementor\Controls_Manager::ICONS,
          'default' => [
            'value' => 'fas fa-star',
            'library' => 'solid',
          ],
   			]
   		);
   		$this->add_control(
   			'icon_4',
   			[
   				'label' => __( 'Icons four', 'negarin' ),
          'type' => \Elementor\Controls_Manager::ICONS,
          'default' => [
            'value' => 'fas fa-star',
            'library' => 'solid',
          ],
   			]
   		);
       $this->add_control(
         'title_color_1',
         [
           'label' => __( 'Icons Color one', 'negarin' ),
           'type' => \Elementor\Controls_Manager::COLOR,
           'scheme' => [
             'type' => \Elementor\Core\Schemes\Color::get_type(),
             'value' => \Elementor\Core\Schemes\Color::COLOR_1,
           ],
           'selectors' => [
             '{{WRAPPER}} .title' => 'color: {{VALUE}}',
           ],
         ]
       );
       $this->add_control(
         'title_color_2',
         [
           'label' => __( 'Icons Color two', 'negarin' ),
           'type' => \Elementor\Controls_Manager::COLOR,
           'scheme' => [
             'type' => \Elementor\Core\Schemes\Color::get_type(),
             'value' => \Elementor\Core\Schemes\Color::COLOR_1,
           ],
           'selectors' => [
             '{{WRAPPER}} .title' => 'color: {{VALUE}}',
           ],
         ]
       );
       $this->add_control(
         'title_color_3',
         [
           'label' => __( 'Icons Color three', 'negarin' ),
           'type' => \Elementor\Controls_Manager::COLOR,
           'scheme' => [
             'type' => \Elementor\Core\Schemes\Color::get_type(),
             'value' => \Elementor\Core\Schemes\Color::COLOR_1,
           ],
           'selectors' => [
             '{{WRAPPER}} .title' => 'color: {{VALUE}}',
           ],
         ]
       );
       $this->add_control(
         'title_color_4',
         [
           'label' => __( 'Icons Color four', 'negarin' ),
           'type' => \Elementor\Controls_Manager::COLOR,
           'scheme' => [
             'type' => \Elementor\Core\Schemes\Color::get_type(),
             'value' => \Elementor\Core\Schemes\Color::COLOR_1,
           ],
           'selectors' => [
             '{{WRAPPER}} .title' => 'color: {{VALUE}}',
           ],
         ]
       );
       $this->add_control(
         'show_title_1',
         [
           'label' => __( 'Show Icons one', 'negarin' ),
           'type' => \Elementor\Controls_Manager::SWITCHER,
           'label_on' => __( 'Show', 'negarin' ),
           'label_off' => __( 'Hide', 'negarin' ),
           'return_value' => 'yes',
           'default' => 'yes',
         ]
       );
       $this->add_control(
         'show_title_2',
         [
           'label' => __( 'Show Icons two', 'negarin' ),
           'type' => \Elementor\Controls_Manager::SWITCHER,
           'label_on' => __( 'Show', 'negarin' ),
           'label_off' => __( 'Hide', 'negarin' ),
           'return_value' => 'yes',
           'default' => 'yes',
         ]
       );
       $this->add_control(
         'show_title_3',
         [
           'label' => __( 'Show Icons three', 'negarin' ),
           'type' => \Elementor\Controls_Manager::SWITCHER,
           'label_on' => __( 'Show', 'negarin' ),
           'label_off' => __( 'Hide', 'negarin' ),
           'return_value' => 'yes',
           'default' => 'yes',
         ]
       );
       $this->add_control(
         'show_title_4',
         [
           'label' => __( 'Show Icons four', 'negarin' ),
           'type' => \Elementor\Controls_Manager::SWITCHER,
           'label_on' => __( 'Show', 'negarin' ),
           'label_off' => __( 'Hide', 'negarin' ),
           'return_value' => 'yes',
           'default' => 'yes',
         ]
       );
   $this->end_controls_section();
   $this->start_controls_section(
     'section_style',
     [
       'label' => __( 'Style', 'negarin' ),
       'tab' => \Elementor\Controls_Manager::TAB_STYLE,
     ]
   );
   $this->end_controls_section();
 }
 private function grid_pagination_section() {
   $this->start_controls_section(
     'section_grid_pagination',
     [
       'label'     => __( 'Pagination', 'negarin' ),
       'condition' => [
         'section_grid.grid_pagination' => 'yes',
       ],
     ]
   );

   // Pagination alignment.
   $this->add_responsive_control(
     'grid_pagination_alignment',
     [
       'label'     => __( 'Alignment', 'negarin' ),
       'type'      => \Elementor\Controls_Manager::CHOOSE,
       'options'   => [
         'left'    => [
           'title' => __( 'Left', 'negarin' ),
           'icon'  => 'fa fa-align-left',
         ],
         'center'  => [
           'title' => __( 'Center', 'negarin' ),
           'icon'  => 'fa fa-align-center',
         ],
         'right'   => [
           'title' => __( 'Right', 'negarin' ),
           'icon'  => 'fa fa-align-right',
         ],
       ],
       'default'   => 'center',
       'tablet_default'   => 'center',
       'mobile_default'   => 'center',
       'selectors' => [
         '{{WRAPPER}} .obfx-grid-pagination .pagination' => 'text-align: {{VALUE}};',
       ],
     ]
   );

   $this->end_controls_section();
 }
 private function grid_pagination_style_section() {
   // Tab.
   $this->start_controls_section(
     'section_grid_pagination_style',
     [
       'label' => __( 'Pagination', 'negarin' ),
       'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
       'condition' => [
         'section_grid.grid_pagination' => 'yes',
       ],
     ]
   );

   // Image margin.
   $this->add_control(
     'grid_pagination_style_margin',
     [
       'label'      => __( 'Margin', 'negarin' ),
       'type'       => \Elementor\Controls_Manager::DIMENSIONS,
       'size_units' => [ 'px' ],
       'selectors'  => [
         '{{WRAPPER}} .obfx-grid-pagination .pagination' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
       ],
     ]
   );

   $this->end_controls_section();
 }


 protected function render() {
       $settings = $this->get_settings();
       $target = $settings['website_link']['is_external'] ? ' target="_blank"' : '';
       $nofollow = $settings['website_link']['nofollow'] ? ' rel="nofollow"' : '';
       ?>
       <div class="container">
       <section class="background_box_article col-12">
       <header class="col title-five">
         <a class="inner-card" href="<?php the_permalink(); ?>">
           <h4 class="Survey-title"><?php echo $settings['title']; ?></h4>
           <?php
           if ( 'yes' === $settings['show_more'] ) {
             echo '<a class="Survey-bt-mor" href="' . $settings['website_link']['url'] . '"' . $target . $nofollow . '>'; echo $settings['title_more'];'';?></a>
             <?php } ?>
               </a>
            </header>
             <?php
       $args = array();
       $args['post_status'] = 'publish';
       $args['ignore_sticky_posts'] = 1;
       if ( ! empty( $settings['grid_post_type'] ) && post_type_exists( $settings['grid_post_type'] ) ) {
         $args['post_type'] = $settings['grid_post_type'];
       }
       if ( ! empty( $settings['grid_post_categories'] ) && $settings['grid_post_type'] == 'post' ) {
         $args['category_name'] = $settings['grid_post_categories'];
       }
       if ( ! empty( $settings['grid_product_categories'] ) && $settings['grid_post_type'] == 'product' ) {
         $args['tax_query'] = array(
           'relation' => 'AND',
           array(
             'taxonomy' => 'product_cat',
             'field' => 'slug',
             'terms' => $settings['grid_product_categories'],
           ),
         );
       }
       if ( ! empty( $settings['grid_items'] ) && intval( $settings['grid_items'] ) == $settings['grid_items'] ) {
         $args['posts_per_page'] = $settings['grid_items'];
       }
       if ( ! empty( $settings['grid_order_by'] ) ) {
         $args['orderby'] = $settings['grid_order_by'];
       }
       if ( ! empty( $settings['grid_pagination'] ) ) {
         $paged = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1;
         $args['paged'] = $paged;
       }
       $query = new \WP_Query( $args );
       if ( $query->have_posts() ) {
         while ( $query->have_posts() ) {
           $query->the_post();
           ?>
           <div class="col-12 col-xl-3 col-md-4 col-sm-6 col-xs-12 right">
             <div class="card-home card-chart" data-count="11">
               <div class="card-head card-header-rose" data-header-animation="true">
                 <?php
                 if(has_post_thumbnail()){
                   the_post_thumbnail( array(200, 200) , array('alt'=>''.get_the_title(),'title'=>''.get_the_title().''));
                 } else { ?>
                   <img src="<?php print(get_template_directory_uri()); ?>/assets/images/thumb.gif" width="60" height="60" alt="<?php  _e( 'Image not found', 'negarin' ); ?>" title="<?php _e( 'Image not found', 'negarin' ); ?>">
                 <?php } ?>
               </div>
               <div class="card-body">
                 <div class="card-actions">
                     <?php
                     if ( 'yes' === $settings['show_title_1'] ) { ?> <a target="_blank" href="<?php echo __get_meta( '__application0' ); ?>" style="color: <?php echo $settings['title_color_1'] ?>"><?php \Elementor\Icons_Manager::render_icon( $settings['icon_1'], [ 'aria-hidden' => 'true' ] ); ?></a>  <?php }
                     if ( 'yes' === $settings['show_title_2'] ) { ?> <a target="_blank" href="<?php echo __get_meta( '__application1' ); ?>" style="color: <?php echo $settings['title_color_2'] ?>"><?php \Elementor\Icons_Manager::render_icon( $settings['icon_2'], [ 'aria-hidden' => 'true' ] ); ?></a>  <?php }
                     if ( 'yes' === $settings['show_title_3'] ) { ?> <a target="_blank" href="<?php echo __get_meta( '__application2' ); ?>" style="color: <?php echo $settings['title_color_3'] ?>"><?php \Elementor\Icons_Manager::render_icon( $settings['icon_3'], [ 'aria-hidden' => 'true' ] ); ?></a>  <?php }
                     if ( 'yes' === $settings['show_title_4'] ) { ?> <a target="_blank" href="<?php echo __get_meta( '__application3' ); ?>" style="color: <?php echo $settings['title_color_4'] ?>"><?php \Elementor\Icons_Manager::render_icon( $settings['icon_4'], [ 'aria-hidden' => 'true' ] ); ?></a>  <?php }
                     ?>
               </div>
               <h4 class="card-title-h">
                 <a href="<?php the_permalink(); ?>"> <?php the_title(); ?></a>
               </h4>
             </div>
             <div class="card-footer">
               <div class="stats">
                 <?php
                   if( get_the_modified_date() != get_the_date() ){
                     echo 'اخرین بروز  رسانی در' . get_the_modified_date('j F Y ساعت H:i');
                   }
                 ?>
               </div>
             </div>
           </div>
          </div>
           <?php
         }
         if ( ! empty( $settings['grid_pagination'] ) ) {
         ?>
         <div class="pagination root"style="width: 100%;">
           <?php
           $big = 999999999;
           $totalpages = $query->max_num_pages;
           $current = max( 1, $paged );
           $paginate_args = array(
             'base'      => str_replace( $big, '%#%', esc_url( get_pagenum_link( $big ) ) ),
             'format'    => '?paged=%#%',
             'current'   => $current,
             'total'     => $totalpages,
             'show_all'  => false,
             'end_size'  => 1,
             'mid_size'  => 3,
             'prev_next' => true,
             'prev_text'          => __( '<i class="fa fa-chevron-right" aria-hidden="true"></i>', 'negarin' ),
             'next_text'          => __( '<i class="fa fa-chevron-left" aria-hidden="true"></i>', 'negarin' ),
             'screen_reader_text' => __( 'A' , 'negarin')
           );
           $pagination = paginate_links( $paginate_args );
           ?>
           <nav class="pagenumbers">
             <?php echo $pagination; ?>
           </nav>
         </div>
         <?php
         }
       } // end if; ?>
       </section>
       </div>
       <?php
     }
   }
